//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.5
import QtQuick.Layouts 1.2

import wesual.Ui     1.0
import wesual.Create 1.0
import wesual.Stage  1.0
import wesual.Editor 1.0

import wesual.data.Core   1.0

import wesual.module.MediaManager 1.0

RowLayout {
    id : mediaPicker

    property Asset mediaAsset

    signal mediaPicked(var media)
    signal removeMedia()

    spacing : 10

    QtObject {
        id : media

        function show() {
            var dialog = ModuleManager.globalInstance(
                        "wesual.dialog.MediaLocation");

            function cb(result) {
                mediaPicker.mediaPicked(result[0]);
            }

            dialog.open({
                callback : cb
            });
        }
    }

    Item {
        width  : 120
        height : 120

        Rectangle {
            anchors.fill : parent
            visible      : !mediaAsset
            border {
                width : 1
                color : UiColors.getColor(UiColors.SeparatorLineGrey17)
            }
            UiToolButton {
                anchors.fill : parent
                iconName     : "add"
                onClicked    : media.show()
            }
        }

        AssetThumbnail {
            id : thumbnail

            asset   : mediaAsset
            visible : mediaAsset

            RestrictedAction {
                id : mediaExportPermission

                author : Creator.context.activeAuthor
                requiredPermissions : [ "wesual.permission.media.export" ]
            }

            UiContextMenu {
                UiMenuItem {
                    text        : qsTrId("89d508c4045e234b")
                    iconName    : "edit-image"
                    enabled     : mediaAsset &&
                                  mediaAsset.accessLevel >= Document.WriteAccess
                    onTriggered : effectEditor.show()
                }
                UiMenuItem {
                    iconName    : "exchange-image"
                    text        : qsTrId("26e3dacd662ab645")
                    onTriggered : media.show()
                }
                UiMenuItem {
                    text        : qsTrId("20a6841438e76421")
                    iconName    : "export"
                    enabled     : mediaAsset && mediaExportPermission.enabled
                    visible     : mediaExportPermission.enabled
                    onTriggered : exporter.exportImages()
                }
                UiMenuItem {
                    text        : qsTrId("55902e7bfeb9f53a")
                    iconName    : "remove"
                    enabled     : mediaAsset
                    onTriggered : removeMedia()
                }
            }
            UiTooltip {
                id : tooltip

                text : {
                    if (!mediaAsset)
                        return "";

                    var text = mediaAsset.fileName;
                    var size = mediaAsset.size;
                    text += " (" + size.width + "x" + size.height + ")";

                    return text;
                }
            }
        }
    }

    ColumnLayout {
        Layout.alignment : Qt.AlignTop

        UiToolButton {
            iconName  : "edit-image"
            text      : qsTrId("89d508c4045e234b")
            enabled   : mediaAsset &&
                        mediaAsset.accessLevel >= Document.WriteAccess
            onClicked : effectEditor.show()
        }
        UiToolButton {
            iconName  : "exchange-image"
            text      : qsTrId("26e3dacd662ab645")
            onClicked : media.show()
        }
    }

    Item {
        Layout.fillWidth : true

        ImageExporter {
            id : exporter

            assets : [ mediaAsset ]
        }
    }

    ImageEffectEditor {
        id : effectEditor

        image  : mediaAsset
    }
}
